	close all
	clear all
	clc
	% EXAMPLE 8.6 Bandpass		
	Wc1 = 6*10^6; Wc2 = 12*10^6;
	Ws1 = 4.8*10^6; Ws2 = 15*10^6;
	if Wc1*Wc2 <= Ws1*Ws2;					% Modify band edges if needed
		Ws2 = Wc1*Wc2/Ws1;	
	else
		Ws1 = Wc1*Wc2/Ws2;	
	end
	r = 0.5; Amax = -10*log10(1-r^2); Amin = 37;
	Rs = 50; RL = 50;
	Wc = Wc2 - Wc1; Ws = Ws2 - Ws1; WIsquared = Wc1*Wc2;  
	Ladder = 1; 	% 1 for a T ladder and 0 for a  ladder
	N = CH_ORDER_S(Wc, Ws, Amax, Amin)
	N = 5;			% Must be an integer. We select a 5th-order filter
	[L, C, K] = CH_I_LADDER(Wc, Ws, Amax, Amin, N, Rs, RL, Ladder)
	[L, C, K] = LP_2_BP_LADDER(L, C, K, WIsquared);
	Z0 = []; T = 1;	% Used only for transmission lines
	omega = Ws2*[eps:0.001:2];
 
	H = LADDER_2_H(N, Z0, L, C, Rs, RL, K, omega, T);
	subplot('position', [0.08 0.4 0.90 0.5]);
	Att = MAG_2_ATT(H*2);		% Normalize the passband to 0 dB
	PLOT_ATT_S(omega, Att);
	
	axis([0, 2*Ws2, 0, 60]);
	L = L'
	C = C'
	W0 = 1./sqrt(L.*C)
	zoom on
